#
# awk script to produce consistent headers for
# issues of mailing list digest.  It includes the
# obvious headers while omitting transport delivery
# information.
#
BEGIN{out=0}
out==1{print;continue}
/^From /{from1=1;print}
/^From: /{from2=1;print}
/^Date: /{date=1;print}
/^Precedence: /{precedence=1;print}
/^Reply-To: /{reply=1;print}
/^Subject: /{subject=1;print}
/^$/{out=1}
END{
	if(!out)		err="nothing output!";
	else {
	  err="";
	  if(!from1)		err=err " no from1";
	  if(!from2)		err=err " no from2";
	  if(!date)		err=err " no date";
	  if(!precedence)	err=err " no precedence";
	  if(!reply)		err=err " no reply";
	  if(!subject)		err=err " no subject";
	}
	if(err!="")
		system("echo " err " 1>&2");
}
